#!/bin/perl
#
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: scripts/parasim2.pl
# Copyright (C) 2004 - 2005 The T2 SDE Project
# Copyright (C) 1998 - 2003 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

use strict;
use English;

my $logdir = $ARGV[0];
my $config = $ARGV[1];
my $id = $ARGV[2];

my $freejobs = $id;
my $runningjobs = 0;
my $now = 0;

my %jobs;
my $qid;

system("mkdir -p $logdir/logs_$id");

open(LOG, "> $logdir/parasim_$id.log") || die $!;
open(DAT, "> $logdir/parasim_$id.new") || die $!;

$|=1; print "Running simulation for $id parallel jobs ...";

while (1) {
	printf LOG "%10d: %d jobs currently running (%d idle)\n",
	           $now, $runningjobs, $freejobs;
	printf DAT "%f\t$runningjobs\t%s\n",
	           $now / 360000, join(" ", keys %jobs);
	print ".";

	foreach $qid (keys %jobs) {
		next if $jobs{$qid} > $now;
		printf LOG "%10d: Finished job $qid.\n", $now;
		system("rm -f $logdir/logs_$id/$qid.* ; " .
		       "touch $logdir/logs_$id/$qid.log");
		$freejobs++; $runningjobs--; delete $jobs{$qid};
	}

	open(Q, "./scripts/Create-PkgQueue -cfg $config " .
	        "-logdir $logdir/logs_$id | sort -r -n -k2 |") || die $!;
	while ($_=<Q> and $freejobs > 0) { 
		@_ = split /\s+/; $qid="$_[0]-$_[5]";
		s/^.*\s(\S+)\s*$/$1/; $_++;
		printf LOG "%10d: Creating new job $qid " .
		           "(pri $_[1], tm $_).\n", $now;
		system("rm -f $logdir/logs_$id/$qid.* ; " .
		       "touch $logdir/logs_$id/$qid.out");
		$jobs{$qid} = $now + $_;
		$freejobs--; $runningjobs++;
	}
	close(Q);

	$_=-1;
	foreach $qid (keys %jobs) {
		$_=$jobs{$qid} if $_ == -1 or $_ > $jobs{$qid};
	}
	if ($_ == -1) { last; } else { $now=$_; }
}

printf DAT "%f\t0\n", $now / 360000;
print "\nSimulated build for $id parallel jobs finished.\n\n";

close LOG; close DAT;
system("mv $logdir/parasim_$id.new $logdir/parasim_$id.dat");
