#!/usr/bin/perl -w
#
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: scripts/patch-pp.pl
# Copyright (C) 2004 - 2005 The T2 SDE Project
# Copyright (C) 1998 - 2003 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---
#
# ROCK Linux "Patch Postprozessor"
#
# This script runs as part of the './scripts/Internal' diff command
# and cleans up the patch 'Clifford' style...

use English;
use strict;

my $skipit=0;
my ($line,$a,$b);

if ($#ARGV != 0 or not -d $ARGV[0]) {
	print STDERR "Usage: $0 Reference-Dir\n" ; exit 1
}

while (<STDIN>) {
	$line=$_;
        if (m,^--- rock-old/([^/]+)/(\S+)\s,) {
		$skipit=0; $a=$1; $b=$2;
		while ($b=~s,^([^/]+)/?,,) {
			$a.="/".$1; $skipit=1 if -l "$ARGV[0]/$a";
			# print STDERR "Checked $a ($skipit)\n";
		}
		
        }
        print $line unless $skipit;
}

0;
