#!/bin/sh
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: target/router/pkgsel.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---
#
# We only need iptables, ip+tc, ssh and a kernel. But since we would
# make a native build we need a lot of other stuff for building those
# packages. This is autodetected here.
#
# Various small other packages (like bash and fileutils) which are
# also needed for the router are selected automatically because of the
# dependencies ...

perl -e '
	my @x=qw/iptables iproute2 openssh linux24 util-linux time
	         coreutils procps strace pciutils bash bdb bzip2
		 e2fsprogs gcc gdbm glibc gzip linux26 linux-header
		 man module-init-tools modutils net-tools openssl
		 patch pcmcia-cs perl psutils tar tcsh zlib 
		 sysvinit 00-dirtree stone mkinitrd rocknet/;
	$b{$_}=1 foreach @x;
	print "\n";
	print "ALL: ".join(" ", @x)."\n";
	print "\n";
	while (<>) {
		next unless /(.*): [0-9]* [0-9]* (.*)/;
		my ($pkg, $deps) = ($1, '');
		foreach (split /\s+/, $2) {
			next if /^(alsa|rpm|pam)([^a-z]|$)/;
			next unless -d "../../package/base/$_";
			$deps .= " $_"; $b{$_} = 1;
		}
		print "$pkg: $deps\n\t\@echo \"\/ $pkg \/ { p; d; }\"\n";
		$a{$pkg} = 1;
	}
	foreach (keys %b) { print "$_:\n\t\@echo \"/ $_ / { p; d; }\"\n\n" if not defined $a{$_}; }
' < ../../scripts/dep_db.txt > pkgsel.mk

echo '# This file is auto-generated from pkgsel.sh' > pkgsel.sed
make -f pkgsel.mk ALL 2> /dev/null | sort -u >> pkgsel.sed
echo 'd;' >> pkgsel.sed; rm -f pkgsel.mk

