#!/usr/bin/perl
#
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: scripts/parasim1.pl
# Copyright (C) 2004 - 2005 The T2 SDE Project
# Copyright (C) 1998 - 2003 ROCK Linux Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

my $size_x=70;
my $size_y=17;

my @data_val;
my @data_nr;
my $max_x = 0;
my $max_y = 0;

my ($x, $y);

open(F, $ARGV[0]) || die $!;
while (<F>) {
	@_ = split /\s+/;
	$max_x++;
	$max_y=$_[1] if $_[1] > $max_y;
}
close F;

open(F, $ARGV[0]) || die $!;
for ($x=0; <F>; $x++) {
	@_ = split /\s+/;
	$_ = int(($x*$size_x) / $max_x);

	$data_val[$_] = 0 unless defined $data_val[$_];
	$data_nr[$_]  = 0 unless defined $data_nr[$_];

	$data_val[$_] += $_[1];
	$data_nr[$_]++;
}
close(F);

$max_y=$ARGV[1] if $ARGV[1] > 0;

my @leftlabel=qw/. . P a r a l l e l . J o b s . ./;

print "\n  ----+----------------------------------------" .
      "------------------------------+\n";

for ($y=$size_y; $y>0; $y--) {
	if ($y == $size_y) { printf("  %3d |", $max_y); }
	elsif ($y == 1) { print "    1 |"; }
	else {
		print "    ", ($leftlabel[$size_y - $y] ne '.' ?
                              $leftlabel[$size_y - $y] : ' '), " |";
	}

	for ($x=0; $x<$size_x; $x++) {
		$_ = ($data_val[$x]*$size_y*2 / $data_nr[$x]) / $max_y;
		if ($_ >= $y*2-1) { print ":"; }
		elsif ($_ >= $y*2-2) { print "."; }
		else { print " "; }
	}
	print "|\n";
}

print "  ----+----------------------------------------" .
      "------------------------------+\n";

printf("      | 1                  Number of Jobs build so far  " .
       "               %5d |\n\n", $max_x);
