/*  gcc -Wall -O2 scrsav.c -o scrsav
 *  while : ; do ./scrsav /dev/vcc/a2 /dev/vcc/a3 ; sleep 5 ; done
 *
 * --- T2-COPYRIGHT-NOTE-BEGIN ---
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * 
 * T2 SDE: misc/archive/scrsav.c
 * Copyright (C) 2004 - 2005 The T2 SDE Project
 * Copyright (C) 1998 - 2003 ROCK Linux Project
 * 
 * More information can be found in the files COPYING and README.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License. A copy of the
 * GNU General Public License can be found in the file COPYING.
 * --- T2-COPYRIGHT-NOTE-END ---
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <endian.h>

#ifdef iMAC_CON
#  define LINES 48
#  define CHARS 128
#else
#  define LINES 25
#  define CHARS 80
#endif

#define BUFSIZE (LINES*CHARS*2)
#define LINESIZE (CHARS*2)

int main(int argc, char ** argv) {
	char buffer[BUFSIZE];
	char miscdata[4];
	int fd,c,i,j;

	if (argc != 3) {
		fprintf(stderr, "Usage: %s <src-vcs> <trg-vcs>\n", argv[0]);
		fprintf(stderr, "E.g.: %s /dev/vcc/a2 /dev/vcc/a3\n", argv[0]);
		return 1;
	}

	fd=open(argv[1], O_RDONLY);
	if (fd < 0) { perror(argv[1]); return 1; }
	read(fd, miscdata, 4);
	read(fd, buffer, BUFSIZE);
	close(fd);

	srandom( time(NULL) + getpid() );

	for (c=0; c<BUFSIZE-1; c+=2) {
#if __BYTE_ORDER == __LITTLE_ENDIAN
		i=c+1; j=c;
#else
		j=c+1; i=c;
#endif
		buffer[i] ^= buffer[j] ^ c ^ random() ;
		if ( c/LINESIZE+1 != time(NULL) % LINES )
			buffer[i] &= 0x0f;
	}
	
	fd=open(argv[2], O_WRONLY);
	if (fd < 0) { perror(argv[2]); return 1; }
	write(fd, miscdata, 4);
	write(fd, buffer, BUFSIZE);
	close(fd);
	
	return 0;
}
