#!/bin/sh
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: misc/archive/PackBuildInfo.sh
# Copyright (C) 2004 - 2005 The T2 SDE Project
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

config=default
if [ "$1" == "-cfg" ]; then
	config=$2; shift; shift
fi

if [ ! -f config/$config/config ]; then
	echo "ERROR: $config not found!"
	exit 1
fi

eval `grep "SDECFG_ID=" config/$config/config`

if [ -z "$SDECFG_ID" -o ! -d build/$SDECFG_ID/var/adm/logs/ ]; then
	echo "ERROR: '$SDECFG' is not a valid build id!"
	exit 2
fi

tmpdir=`mktemp -d`
rev=`svn info | sed -n 's,^Revision: \(.*\),\1,p'`
mkdir -p $tmpdir/{config,cache,errlogs,flist}	# logs

echo "INFO: backuping configuration of $config ..." 1>&2
cp -av config/$config/* $tmpdir/config/

echo "INFO: creating build summary ..." 1>&2
./scripts/Create-ErrList -cfg $config 2>&1 | tee $tmpdir/summary

echo "INFO: adding cache files ..." 1>&2
#for x in $( cd build/$SDECFG_ID/var/adm/cache; ls -1 ); do
#	[ -s build/$SDECFG_ID/var/adm/cache/$x ] && \
#		cp build/$SDECFG_ID/var/adm/cache/$x $tmpdir/cache/
		cp build/$SDECFG_ID/var/adm/cache/* $tmpdir/cache/
#done

echo "INFO: adding log files ..." 1>&2
#for x in $( cd build/$SDECFG_ID/var/adm/logs; ls -1 ); do
#	if [ -s build/$SDECFG_ID/var/adm/logs/$x ]; then
#		[[ $x == *.out ]] && continue
#		cp build/$SDECFG_ID/var/adm/logs/$x $tmpdir/logs/
		cp build/$SDECFG_ID/var/adm/logs/*.err $tmpdir/errlogs/
#		[[ $x == *.err ]] && ln -s ../logs/$x $tmpdir/errlogs/$x
#	fi
#done

echo "INFO: adding flist files ..." 1>&2
#for x in $( cd build/$SDECFG_ID/var/adm/flists; ls -1 ); do
#	[ -s $x ] && cp build/$SDECFG_ID/var/adm/flists/$x $tmpdir/flist/
	cp build/$SDECFG_ID/var/adm/flists/* $tmpdir/flist/
#done

tar -C $tmpdir -jcf cachepack-$config-t2-r${rev:-0}.tar.bz2 .

rm -rf $tmpdir
